################################################################################
#
# Matlab package, version 2.0
#
# This is a set of TCL proc's that allow the shareware Macintosh text editor 
# Alpha to act as a front end for MATLAB for Macintosh version 5.0 or 
# higher.  Requires Alpha 7.0 or higher.  See file "Matlab Help" for more 
# information.
#
################################################################################

alpha::mode MATL 2.0 dummyMATL {*.m *.M} {MATLMenu electricTab} {
    alpha::package require -loose Alpha 7.0
} maintainer {
    "Stephen M. Merkowitz" Stephen.Merkowitz@lnf.infn.it
} uninstall this-directory


#################################################################################
# Autoload procedures
################################################################################

proc dummyMATL {} {}
proc MATLMenu  {} {}


#################################################################################
# Hooks
################################################################################

hook::register saveHook MATL::saveHook MATL

################################################################################
# Flags and variables
################################################################################

newPref v prefixString     {% }     MATL
newPref v wordBreak        {[_\w]+} MATL
newPref v wordBreakPreface {[^_\w]} MATL
newPref f wordWrap         {0}      MATL

newPref v tabSize  {3} MATL
newPref v funcExpr {^[ \t]*(function|FUNCTION).*\(.*$} MATL

newPref f electricSemi 1 MATL
newPref f elecReturn   1 MATL

newPref f DblClickEdits  0 MATL
newPref f clearOnSave    0 MATL
newPref f webHelp        0 MATL

newPref v CmdWinName     {*Matlab Commands*} MATL
newPref v CmdHistWinName {*Command History*} MATL

newPref v MatlabHelpFolder "" MATL

newPref f queEventsQuietly  0 MATL


set commentCharacters(MATL:General) "% "
set commentCharacters(MATL:Paragraph) [list "% " "% " "% "]
set commentCharacters(MATL:Box) [list "%" 1 "%" 1 "%" 3]


################################################################################
# Colorization
################################################################################

newPref v keywordColor      blue    MATL
newPref v keyVariablesColor green   MATL
newPref v punctuationColor  magenta MATL

set matKeywords { 
	break else elseif end for if return while function switch case otherwise
	global eval feval nargchk pause menu keyboard input ...
}

set matKeyVariables { 
	ans computer eps flops inf NaN pi realmax realmin 
	nargin nargout varargout varargin
}

regModeKeywords -e {%} -c red -k $MATLmodeVars(keywordColor) MATL $matKeywords  \
	-i {[} -i {]} -i {(} -i {)} -i {,} -i {;} -I $MATLmodeVars(punctuationColor)

regModeKeywords -a -k $MATLmodeVars(keyVariablesColor) MATL $matKeyVariables

unset matKeywords
unset matKeyVariables


################################################################################
#  global variables
################################################################################

set commandHistory [list]
set commandNum 0
set lastMatlabResult ""
set matlabSig {MATL}
if {![info exists MATLMenu]} {set MATLMenu "405"}
set matlabBusy 0
set MATLeventQue [list]


################################################################################
#  Bind some keys
################################################################################

bind '\r' <z>  matlabDoLine              "MATL"
bind up        matlabUp                  "MATL"
bind down      matlabDown                "MATL"
bind 'u'  <z>  matlabCancelLine          "MATL"
bind '\;' <o>  MATL::electricSemiJump    "MATL"
bind '\r'      bind::MATLcarriageReturn  "MATL"


################################################################################
#  Load the rest of the matlab package
################################################################################

foreach f {Comm Engine Macros Menu Windows Doc HTML Completions} {
	 if [catch [set f "matlab${f}.tcl"]] {
		  alertnote "Loading of $f failed!"
	 }
}
unset f
